#ifndef _PLAYER_
#define _PLAYER_
typedef enum PlayerType PlayerType;
typedef struct Player Player;
enum PlayerType {
    PlayerNone,
    PlayerWitch,
    PlayerBumblebee,
    PlayerPyramidtree,
    PlayerOpossum,
    PlayerWoodPecker,
    PlayerBeaver,
    PlayerRacoon,
    PlayerSkunk,
    PlayerFox,
    PlayerVillain,
    PlayerFireball,
    PlayerRootspell,
    PlayerBirdDropping,
    PlayerAardvark,
    PlayerAnteater,
    PlayerStar,
    PlayerIcicle,
    PlayerTypes
};
#include "game.h"
#include "animation.h"
struct Player {
    LandSpriteAnimated super;
    float x, y;
    float dx, dy;
    bool left;
    bool ground;
    int out_door;
    bool placed;
    bool dead;
    int attacking;
    bool attack2;
    int lifes;
    int bound;
    bool once;
    int pause_counter;
    int recharging;
    AnimationState anim;
    int anim_t;
    char * text;
    int text_t;
    PlayerType pt;
    int variant;
    PlayerType origin;
    bool removed /* was removed, but internally still in the removed list */;
};
void player_transfer(Player * self, Player * from_old);
Player* player_make(PlayerType pt, float x, float y);
void player_remove(Player * p);
void player_place(Player * self, float x, float y);
void player_unplace(Player * self);
void player_look(Player * self, int dx);
void player_draw(LandSprite * self, LandView * view, LandGrid * grid);
bool player_have_animation_frame(Player * p, int frame);
Player* make_projectile(int what, Player * p, int x, int y, int dx, int dy);
void player_tick(Player * p);
void player_move_by_input(Player * p, int kx, int ky);
void player_move_projectile(Player * p);
void player_fly_horizontal(Player * p, float speed);
void player_check_below(Player * p);
void player_walk_horizontal(Player * p, float speed);
Player* player_find(PlayerType pt);
void player_flip(Player * p);
void player_cancel_texts(void);
#endif
